<?php

namespace App\Controllers;

use CodeIgniter\RESTful\ResourceController;
use CodeIgniter\HTTP\RequestInterface;

class BaseApiController extends ResourceController
{
    protected function validateToken()
    {
        $authHeader = $this->request->getHeaderLine('Authorization');

        // if (!$authHeader || !preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
        //     return $this->failUnauthorized('Missing or invalid JWT token');
        // }

        if (!$authHeader || !preg_match('/Bearer\s(\S+)/', $authHeader, $matches)) {
            return $this->respond([
                'status' => 0,
                'message' => 'Missing or invalid JWT token'
            ], 200); // Return custom response instead of error
        }

        $decoded = decodeJWT($matches[1]);

        // if (!$decoded) {
        //     return $this->failUnauthorized('Invalid token');
        // }
        if (!$decoded) {
            return $this->respond([
                'status' => 0,
                'message' => 'Token expired'
            ], 200); // Return custom response instead of error
        }
        return $decoded;
    }
}
