<?php

namespace App\Controllers;
use App\Libraries\Paginator;
use App\Models\UserModel;


class UserController extends BaseApiController
{
    public function addUser()
    {
        $decoded = $this->validateToken();
        if (!$decoded) return $this->failUnauthorized("Unauthorized");

        // Get data from the request
        $first_name = $this->request->getVar('first_name');
        $last_name = $this->request->getVar('last_name');
        $email = $this->request->getVar('email');
        $phone = $this->request->getVar('phone');
        $designation = $this->request->getVar('designation');
        $additionaldetails = $this->request->getVar('additionaldetails');
        $user_status = $this->request->getVar('user_status');
        $password = $this->request->getVar('password');

        // Backend validation to ensure no empty fields
        if (empty($first_name) || empty($last_name) || empty($email) || empty($phone) || empty($user_status) || empty($password)) {
            return $this->fail("All fields are required.", 200); 
        }
        // Validate Phone Number (Exactly 10 Digits)
        if (!preg_match('/^[0-9]{10}$/', $phone)) {
            return $this->fail("Phone number must be exactly 10 digits.", 200);
        }
        $model = new UserModel();

        // Check for duplicate email
        if ($model->where('email', $email)->first()) {
            //return $this->fail("Email is already registered.", 200);
            return $this->fail([
                'status' => 0,
                'message' => 'Email is already registered',
                'data' => null
            ], 200);
        }

        // Check for duplicate phone
        if ($model->where('phone', $phone)->first()) {
            //return $this->fail("Phone number is already registered.", 200);
            return $this->fail([
                'status' => 0,
                'message' => 'Phone number is already registered',
                'data' => null
            ], 200);
        }
        $data = [
            'first_name' => $this->request->getVar('first_name'),
            'last_name' => $this->request->getVar('last_name'),
            'email' => $this->request->getVar('email'),
            'phone' => $this->request->getVar('phone'),
            'designation' => $this->request->getVar('designation'),
            'additionaldetails' => $this->request->getVar('additionaldetails'),
            'user_status' => $this->request->getVar('user_status'),
            'password' => password_hash($this->request->getVar('password'), PASSWORD_DEFAULT),
        ];
        $model->insert($data);

        //return $this->respondCreated(['message' => 'User created successfully']);

        return $this->respond([
            'status' => 1, 
            'message' => 'User created successfully',
            //'token' => $token,
            'data' => $data
        ]);
    }

    public function editUser($userid)
    {
        
        // Validate JWT Token
        $decoded = $this->validateToken();
    
       // if (!$decoded) return $this->failUnauthorized("Unauthorized");
       if ($decoded instanceof \CodeIgniter\HTTP\Response) {
        return $decoded; 
        }
        $model = new UserModel();
        $user = $model->find($userid);
    
        if (!$user) return $this->failNotFound('User not found');
    
        
        $data = $this->request->getJSON(true); 
    
        
    
        if (empty($data)) {
            return $this->fail('No data provided for update', 200);
        }
        // Backend validation to ensure no empty fields
        // if (empty($first_name) || empty($last_name) || empty($email) || empty($phone) || empty($user_status) || empty($password)) {
        //     return $this->fail("All fields are required.", 200); 
        // }
        // Validate Phone Number (if provided)
        if (!empty($data['phone']) && !preg_match('/^[0-9]{10}$/', $data['phone'])) {
            return $this->fail("Phone number must be exactly 10 digits.", 200);
        }

        // Check duplicate email (excluding current user)
        if (!empty($data['email'])) {
            $existingEmailUser = $model->where('email', $data['email'])
                                    ->where('userid !=', $userid)
                                    ->first();
            if ($existingEmailUser) {
                //return $this->fail("Email is already registered.", 200);
                return $this->fail([
                    'status' => 0,
                    'message' => 'Email is already registered',
                    'data' => null
                ], 200);
            }
        }

        // Check duplicate phone (excluding current user)
        if (!empty($data['phone'])) {
            $existingPhoneUser = $model->where('phone', $data['phone'])
                                    ->where('userid !=', $userid)
                                    ->first();
            if ($existingPhoneUser) {
                //return $this->fail("Phone number is already registered.", 200);
                return $this->fail([
                    'status' => 0,
                    'message' => 'Phone number is already registered',
                    'data' => null
                ], 200);
            }
        }

        if (!empty($data['password'])) {
            $data['password'] = password_hash($data['password'], PASSWORD_DEFAULT);
        }
    
        
        if (!$model->update($userid, $data)) {
            //return $this->fail('Failed to update user', 500);
            return $this->fail([
                'status' => 0,
                'message' => 'Failed to update user',
                'data' => null
            ], 200);
            
        }
        $updatedUser = $model->find($userid);

       // return $this->respond(['message' => 'User updated successfully']);
        return $this->respond([
            'status' => 1, 
            'message' => 'User updated successfully',
            //'token' => $token,
            'data' => $updatedUser
        ]);
    }
    

  

// public function getUserList()
// {
//     $decoded = $this->validateToken();

//     if ($decoded instanceof \CodeIgniter\HTTP\Response) {
//         return $this->respond([
//             'status' => 0, 
//             'message' => 'Unauthorized'
//         ], 200); 
//     }

//     $page = (int) $this->request->getGet('page') ?: 1;
//     $limit = (int) $this->request->getGet('limit') ?: 10;

//     $model = new UserModel();
//     $paginator = new Paginator();

//     $result = $paginator->paginate(
//         $model,
//         [], 
//         null, 
//         [],   
//         $page,
//         $limit
//     );

//     return $this->respond([
//         'status' => 1, 
//         'message' => 'User list retrieved successfully',
//         'token' => $this->request->getHeaderLine('Authorization'),
//         'total' => $result['total'],
//         'page' => $result['page'],
//         'limit' => $result['limit'],
//         'data' => $result['data']
//     ]);
// }

    public function search()
    {
        // Validate JWT Token
        $decoded = $this->validateToken();
        if ($decoded instanceof \CodeIgniter\HTTP\Response) {
            return $this->respond([
                'status' => 0,
                'message' => 'Unauthorized'
            ], 200);
        }

        // Get search query and pagination inputs
        $query = $this->request->getGet('query');
        $page = (int) $this->request->getGet('page') ?: 1;
        $limit = (int) $this->request->getGet('limit') ?: 10;

        if (!$query) {
            return $this->respond([
                'status' => 0,
                'message' => 'Search term is required.',
                'data' => null
            ], 200);
        }

        $model = new UserModel();
        $paginator = new Paginator();

        $result = $paginator->paginate(
            $model,
            [], // No additional filters
            $query, // Search term
            ['first_name', 'last_name', 'email', 'phone'], // Searchable fields
            $page,
            $limit
        );

        if (empty($result['data'])) {
            return $this->respond([
                'status' => 0,
                'message' => 'No users found.',
                'data' => [],
                'total' => 0
            ], 200);
        }

        return $this->respond([
            'status' => 1,
            'message' => 'Users searched successfully.',
            'data' => $result['data'],
            'total' => $result['total'],
            'page' => $result['page'],
            'limit' => $result['limit']
        ]);
    }

    public function getUserList()
    {
        $decoded = $this->validateToken();

        if ($decoded instanceof \CodeIgniter\HTTP\Response) {
            return $this->respond([
                'status' => 0, 
                'message' => 'Unauthorized'
            ], 200); 
        }

        $page = (int) ($this->request->getGet('page') ?: 1);
        $limit = (int) ($this->request->getGet('limit') ?: 10);
        $query = $this->request->getGet('query'); 

        $model = new UserModel();
        $paginator = new \App\Libraries\Paginator(); 

        // Optional searchable fields
        $searchFields = ['first_name', 'last_name', 'email', 'phone'];

        $result = $paginator->paginate(
            $model,
            [],          // Additional filters
            $query,      // Optional search term
            $searchFields,
            $page,
            $limit
        );

        return $this->respond([
            'status'  => 1,
            'message' => $query ? 'Search results retrieved successfully' : 'User list retrieved successfully',
            'token'   => $this->request->getHeaderLine('Authorization'),
            'total'   => $result['total'],
            'page'    => $result['page'],
            'limit'   => $result['limit'],
            'data'    => $result['data']
        ]);
    }
    // get user details
    public function getUserById($id)
    {
        $decoded = $this->validateToken();
        if ($decoded instanceof \CodeIgniter\HTTP\Response) {
            return $this->respond([
                'status' => 0,
                'message' => 'Unauthorized'
            ], 200);
        }

        $model = new UserModel();
        $user = $model->find($id);

        if (!$user) {
            return $this->respond([
                'status' => 0,
                'message' => 'User not found',
                'data' => null
            ], 200);
        }

        return $this->respond([
            'status' => 1,
            'message' => 'User retrieved successfully',
            'data' => $user
        ]);
    }


    public function logout()
    {
        $decoded = $this->validateToken();
        
        // If the token is invalid or expired, respond with an unauthorized error
        if ($decoded instanceof \CodeIgniter\HTTP\Response) {
            return $this->respond([
                'status' => 0,
                'message' => 'Unauthorized Token'
            ], 401);
        }
//print_r($decoded);exit();
       // $userId = $decoded->sub; 
        //$userName = $decoded->first_name;

        // Optionally: Check if the token has expired. If it has, return a message indicating that.
        $currentTime = time();
        
        if (isset($decoded->exp) && $decoded->exp < $currentTime) {
            return $this->respond([
                'status' => 0,
                'message' => 'Token has expired. Please log in again.'
            ], 200);
        }

        // Since JWT is stateless, client should delete the token on the frontend.
        return $this->respond([
            'status' => 1,
            'message' => 'User has been logged out successfully.',
            'data' => []
        ]);
    }

}
