<?php

use Firebase\JWT\JWT;
use Firebase\JWT\Key;
//echo 'enter jwt';

function generateJWT($user)
{
    
    $key = getenv('JWT_SECRET');
    //var_dump($user);
    //die();
    $payload = [
        'iss' => "CodeIgniter4",
        'iat' => time(),
        'exp' => time() + 600, // Token valid for 10 min
        'sub' => $user['userid'],
        //'name' => $user['first_name'], 
        'email' => $user['email'],
    ];

    return JWT::encode($payload, $key, 'HS256');
}

function decodeJWT($token)
{
    try {
        $key = getenv('JWT_SECRET');
        return JWT::decode($token, new Key($key, 'HS256'));
    } catch (Exception $e) {
        return null;
    }
}
