<?php namespace App\Libraries;

use Twilio\Rest\Client;

class TwilioService
{
    protected $client;
    protected $from;

    public function __construct()
    {
        $sid   = getenv('twilio.account_sid');
        $token = getenv('twilio.auth_token');
        $this->from = getenv('twilio.phone_number');

        $this->client = new Client($sid, $token);

        
        
    }

    public function sendSMS($to, $message)
    {
        try {
            log_message('debug', "Preparing to send SMS to: $to");
            log_message('debug', "Message content: $message");
       
            $this->client->messages->create($to, [
                'from' => $this->from,
                'body' => $message
            ]);
           
            log_message('info', "✅ SMS sent successfully. SID: " . $result->sid);
            return true;
        } catch (\Exception $e) {
            log_message('error', 'Twilio SMS Error: ' . $e->getMessage());
            return false;
        }
    }
}
